﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BE;
using DS;
using DAL;
using GoogleMapsApi;
using GoogleMapsApi.Entities.Directions.Request;
using GoogleMapsApi.Entities.Directions.Response;
namespace BL
{
   public class Bl_imp : IBL
    {
        DAL.Idal dal;
        public Bl_imp()
        {
            dal = FactoryDAL.GetDal(); 
           
        }
        List<Nanny> Grouping_nannies;
        List<Nanny> nannies_daysOf_asMinistryOfEconomy;
        List<Nanny> the_5_nannies;
        List<Nanny> the_closest_nannies;
        List<Child> children_without_nanny;
        List<Contract> AllContractsAsDemand;
        IEnumerable<IGrouping<int, Nanny>> v;
        IEnumerable<IGrouping<double, Contract>> distanceContrate;


        #region Google Maps
        public static int CalculateDistance(string source, string dest)
        {
            var drivingDirectionRequest = new DirectionsRequest
            {
                TravelMode = TravelMode.Walking,
                Origin = source,
                Destination = dest,
            };
            DirectionsResponse drivingDirections = GoogleMaps.Directions.Query(drivingDirectionRequest);
            Route route = drivingDirections.Routes.First();
            Leg leg = route.Legs.First();
            return leg.Distance.Value;
        }
        #endregion

        #region Nanny functions

        public IEnumerable<Nanny> GetAllNannies(Func<Nanny, bool> predicat = null)
        {
            return dal.GetAllNannies(predicat);
        }

        public void addNanny(Nanny n) //before insert the Nanny into the list, the func checks if she is older than 18th 
        {
            DateTime now = DateTime.Today;
            if ((now.Year - n.B_Day.Year) > 18) 
            {
                dal.addNanny(n);
            }
            else if ((now.Year - n.B_Day.Year) == 18) //if the year is not enogh to check
            {
                if (now.Month > n.B_Day.Month) //checks the month
                {
                    dal.addNanny(n);
                }

                else if (now.Month == n.B_Day.Month) //if the month is not enogh either
                {
                    if (now.Day >= n.B_Day.Day) //checks the day
                    {
                        dal.addNanny(n);
                    }
                    else throw new Exception("SORRY, YOU ARE TOO YOUNG"); //(for the days)
                }
                else throw new Exception("SORRY, YOU ARE TOO YOUNG"); //(for the monthes)
            }
            else throw new Exception("SORRY, YOU ARE TOO YOUNG"); //(for the years)
        }

        public void deleteNanny(Nanny a)
        {
             dal.deleteNanny(a);
        }

        public void updateNannyDtails(Nanny a)
        {
            dal.updateNannyDtails(a);
        }

        public Nanny GetNanny(int Id)
        {
            return DataSource.nannies.FirstOrDefault(c => c.Id == Id); //checks if the nanny exists and insert her to c. else: c=null

        }
        #endregion

        #region Mother's functions

        public IEnumerable<Mother> GetAllMothers(Func<Mother, bool> predicat = null)
        {
            return dal.GetAllMothers(predicat);
        }

        public void addMother(Mother m)
        {
            dal.addMother(m);
        }

      public  void deleteMother(Mother m)
        {
            dal.deleteMother(m);
        }

        public void updateMotherDtails(Mother m)
        {
            dal.updateMotherDtails(m);
        }

        public Mother GetMother(int Id)
        {
            return DataSource.mothers.FirstOrDefault(m => m.Id == Id); //checks if the nanny exists and insert her to c. else: c=null

        }
        #endregion

        #region Child's Functions

        public IEnumerable<Child> GetAllChildren(Func<Child, bool> predicat = null)
        {
            return dal.GetAllChildren(predicat);
        }

       public void addChild(Child c)
        {
            dal.addChild(c);
        }

       public void deleteChild(Child c)
        {
            dal.deleteChild(c);
        }

       public void updateChildDtails(Child c)
        {
            dal.updateChildDtails(c);
            
        }
        public Child GetChild(int Id)
        {
            return DataSource.children.FirstOrDefault(c => c.Id == Id);

        }
  
        
        #endregion

        #region Contract's Functions

        public IEnumerable<Contract> GetAllContracts(Func<Contract, bool> predicat = null)
        {
            return dal.GetAllContracts(predicat);
        }

       public void addContract(Contract co)
        {
            Nanny ncheck = GetNanny(co.NannyId); 
            
            if (ncheck.NumOfKids < ncheck.MaxNumOfKids) //checks if the amount of children is not too big
            {
                DateTime now = DateTime.Today;
                int idChild = co.ChildId;
                Child tmpchild = GetChild(co.ChildId);
                Mother tmpMother = GetMother(tmpchild.MotherId);
                if ((now.Year - tmpchild.B_Day.Year) >= 0) //checks if the child is older then 3 month
                {
                    if (now.Month - tmpchild.B_Day.Month >= 3)
                    {
                        if (now.Day - tmpchild.B_Day.Day >= 0)
                        {
                            
                            if(tmpMother.OptionalAddress!="")
                            co.Distance = CalculateDistance(tmpMother.OptionalAddress, ncheck.Adderss);
                            else co.Distance = CalculateDistance(tmpMother.Address, ncheck.Adderss);
                            dal.addContract(co);
                        }
                        else
                            throw new Exception("THE CHILD IS TOO YUNG");
                    }
                    else
                    {
                        int numMonth = 12 - tmpchild.B_Day.Month + now.Month;
                        if (numMonth > 3)
                        {
                            if (tmpMother.OptionalAddress != "")
                                co.Distance = CalculateDistance(tmpMother.OptionalAddress, ncheck.Adderss);
                            else co.Distance = CalculateDistance(tmpMother.Address, ncheck.Adderss);
                            dal.addContract(co);
                        }
                        else
                        {
                            if (numMonth == 3)
                            {
                                if (now.Day - tmpchild.B_Day.Day > 3)
                                    if (tmpMother.OptionalAddress != "")
                                        co.Distance = CalculateDistance(tmpMother.OptionalAddress, ncheck.Adderss);
                                    else co.Distance = CalculateDistance(tmpMother.Address, ncheck.Adderss);
                                dal.addContract(co);
                            }
                            else
                                throw new Exception("THE CHILD IS TOO YUNG");
                        }
                    }
                }
                else throw new Exception("PLEASE CHECK THE DATE, THE BABY'S AGE IS ILIGAL"); 
            }
            else
            {
                throw new Exception("THIS NANNY IS'NT AVELABALE");
            }
        }

       public void deleteContract(Contract co)
        {
            dal.deleteContract(co);
        }
       public void updateContractDtails(Contract co)
        {
            dal.updateContractDtails(co);
        }
        #endregion

        #region General functions
        public List<Nanny> getNannies()
        {
            return dal.getNannies();
        }
        public List<Mother> getMothers()
        {
            return dal.getMothers();
        }
        public List<Child> getChildren(List<Child> childrenByMothers)
        {
            return dal.getChildren(childrenByMothers);
        }
        public List<Contract> getContract()
        {
            return dal.getContract();
        }
        public double toPay(Mother m, Nanny n, Child c)
        {

            double sum = 0;
            int sumOfHours = 0;
            int counterChildren = 0;
            foreach (Contract item in n.ContractList)
            {
                foreach (Child child in m.ChildrenList)
                {
                    if (item.ChildId == child.Id)
                        counterChildren++;
                }
            }
            if (n.PerHour)
            {
                for (int i = 0; i < 6; i++)
                {
                    if (m.OptionalDays[i] == true)
                    {

                        int sum1 = 0, sum2 = 0, sum3 = 0;
                        sum1 = 60 - (m.WorkingHours[i].BeginingTime.Minutes);
                        sum2 = 60 - (m.WorkingHours[i].EndTime.Minutes);
                        sum3 = (m.WorkingHours[i].EndTime.Hours) - (m.WorkingHours[i].BeginingTime.Hours);
                        sumOfHours += (sum3 * 60 - (sum1 - sum2));

                    }
                    else { }
                }
                sum = sumOfHours * 4;

            }
            else
            {
                sum = n.SalaryPerMonth;
            }
            for (int i = 0; i < counterChildren; i++)
            {
                sum = sum * 0.98;
            }
            return sum;
        }


        public List<Nanny> findTheNannies(Mother m, List<Nanny> properNannies, Child ch)
        {
            foreach (Nanny item in DataSource.nannies)

            {
                double cost = toPay(m, item, ch);
              
                    if (m.MaxPayment <= cost)

                    {
                        bool hours = true;
                        for (int i = 0; i < 6; i++)
                        {
                            if (m.OptionalDays[i])
                            {
                                if (item.WorkingDays[i] == false)
                                { hours = false; }
                                else { }
                            }

                        }
                        if (hours == true)
                        {
                            for (int i = 0; (i < 6) && (hours = true); i++)
                            {
                                if (m.OptionalDays[i])
                                {
                                    if ((item.WorkingHours[i].BeginingTime) <= (m.WorkingHours[i].BeginingTime) && item.WorkingHours[i].EndTime >= m.WorkingHours[i].EndTime)
                                    {

                                    }
                                    else
                                    {
                                        hours = false;
                                    }

                                }
                            }
                            if (hours == true)
                            {
                                properNannies.Add(item);
                            }


                        }
                        else { }

                    }
                    else { }
                
            }
            if (properNannies == null)
                properNannies = findThe_5_Nannies(properNannies, m, ch);
            if (properNannies == null)
                throw new Exception("WE CANT FIND ANY PROPER NANNY. PLEASE UPDATE YOUR DEMANDS");
           else return properNannies;

        }
        public List<Nanny> findThe_5_Nannies(List<Nanny> n,Mother m, Child ch) //returns the nannies that their start & end working hours are the most closet to the mothers demands 
        {                                                            // if it is not enogh, the cost will be more then the mothers request
            int counter = 0;
          
            foreach (Nanny item in DataSource.nannies)
            {
                if(counter<5)
                {
                double cost = toPay(m, item, ch);
                bool hours = true;
                for (int i = 0; i < 6; i++)
                {
                    if (m.OptionalDays[i])
                    {
                        if (item.WorkingDays[i] == false)
                        {
                            if(i!=5) //the mother will compromise on Fridies so the nanny doesnt work on Fridy-it's ok!
                                hours = false;
                        }
                        else { }
                    }

                }
                  if(hours==false)
                if (m.MaxPayment + 500 < cost) //if you cant find any nanny, the mother will compromise on payment  
                {
                    hours = false;
                }
                if (hours == true)
                { 
                    the_5_nannies.Add(item);
                    counter++;
                }
                else { }
            }
            }
            return the_5_nannies;
           
        }

        public List<Nanny> find_closet_nannies(Mother m, List<Nanny> properNannies, Child ch)
        {
            the_closest_nannies = findTheNannies(m, DataSource.nannies,ch );

            if (the_closest_nannies != null)
            {
                foreach (Nanny item in DataSource.nannies)
                {
                    if (m.OptionalAddress != "")
                    {
                        if (CalculateDistance(m.OptionalAddress, item.Adderss) < 1.5)
                        {
                            the_closest_nannies.Add(item);
                        }
                        else
                        {
                            if (CalculateDistance(m.Address, item.Adderss) < 1.5)
                            {
                                the_closest_nannies.Add(item);
                            }
                        }
                    }
                }
                return the_closest_nannies;
            }
            else throw new Exception("WE CANT FIND ANY CLOSE NANNY AS YOU DEMANDED");
}
        public List<Child> getChildrenWithoutNanny()
        {
            foreach (Child item in DataSource.children)
            {
                if(item.NumOfConracts==0)
                {
                    children_without_nanny.Add(item);
                }
            }
            return children_without_nanny;
        }

        public List<Nanny> nannies_daysOf_as_MinistryOfEconomy (List<Nanny> n)
        {
            foreach (Nanny item in DataSource.nannies)
            {
                if(item.DaysOff== true)
                {
                    nannies_daysOf_asMinistryOfEconomy.Add(item);
                }
            }
            return nannies_daysOf_asMinistryOfEconomy;
        }
        
        public delegate bool someDelegate(Contract c );//זה המצביע לפונקציה, בעצם אליו נשלח כל רשימה לבדוק אם היא עומדת בתנאי
        public List<Contract> GetContractsByCondition(someDelegate a)
        {

            var v = from contract in DataSource.contracts //תעבור על כל חוזה ברשימה
                    where a(contract) //null תשלח אותו למצביע הנ"ל ותבדוק האם הוא לא חזר עם ערך 
                    select contract; // v תשים את אותו חוזה שעמד בתנאי בתוך המערך הזמני 
            foreach (var item in v) //עכשיו תעבור על כל איב במערך הזמני ותשים אותו במערך אמיתי (שהגדרנו למעלה) כדי שהוא באמת יישמר
            {
                AllContractsAsDemand.Add(item);
            }
            return AllContractsAsDemand;
        }
        public int NunberOfContractsByCondition(someDelegate a) //זה בעצם אותו דבר רק שבמקום לשמור את האיברים במערך אמיתי אנחנו סופרים כמה יש במערך הזמני ז"א כמה איברים עמדו בתנאי
        {
            int counter = 0;
            var v = from contract in DataSource.contracts
                    where a(contract)
                    select contract;
            foreach (var item in v)
            {
                  counter++;
            }
            return counter;
        }

        public IEnumerable<IGrouping<int, Nanny>>  Grouping_Nannies(bool maxOrMin, bool isSorted=false)
        {
            
            if (maxOrMin==true)
            {
                 v = from n in DataSource.nannies
                        group n by n.MaxAge;
            }
            else if(maxOrMin == false)
            {
                v = from n in DataSource.nannies
                        group n by n.MinAge;
            }
            if(isSorted)
            {
                v = v.OrderBy(x => x.Key);
            }
            return v;
        }
        public IEnumerable<IGrouping<double, Contract>> contacs_by_distance(bool issort=false)
        {
            distanceContrate = from n in DataSource.contracts
                                  group n by n.Distance /5 ;
            
            if (issort)
            {
                distanceContrate = distanceContrate.OrderBy(x => x.Key);
            }
            return distanceContrate;
        }

            #endregion


    }
    }

    

