﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BE;
using DS;
using DAL;

namespace BL
{
    public interface IBL
    {
        #region Nanny's functions
        void addNanny(Nanny a);
        void deleteNanny(Nanny a);
        void updateNannyDtails(Nanny a);
        IEnumerable<Nanny> GetAllNannies(Func<Nanny, bool> predicat = null);
        #endregion

        # region Mother's functions
        void addMother(Mother m);
        void deleteMother(Mother m);
        void updateMotherDtails(Mother m);
        IEnumerable<Mother> GetAllMothers(Func<Mother, bool> predicat = null);
        #endregion

        #region Child's Functions
        void addChild(Child c);
        void deleteChild(Child c);
        void updateChildDtails(Child c);
        IEnumerable<Child> GetAllChildren(Func<Child, bool> predicat = null);
        #endregion

        #region Contract's Functions
        void addContract(Contract co);
        void deleteContract(Contract co);
        void updateContractDtails(Contract co);
        IEnumerable<Contract> GetAllContracts(Func<Contract, bool> predicat = null);
        #endregion

        #region General functions
        List<Nanny> getNannies();
        List<Mother> getMothers();
        List<Child> getChildren(List<Child> childrenByMothers);
        List<Contract> getContract();
         double toPay(Mother m, Nanny n, Child c);
        Nanny GetNanny(int id);
        Child GetChild(int id);
        Mother GetMother(int id);
        #endregion

    }
}
