﻿using BE;
using DS;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using System.Xml.Serialization;

namespace DAL
{
    class Dal_XML_Imp : Idal
    {
        #region Load File Functions

        string motherPath = @"Mothers.xml";
        string nannyPath = @"Nannies.xml";
        string childPath = @"Children.xml";
        string contractPath = @"Contracts.xml";
        XElement ChildrenRoot;
        XElement MotherRoot;
        XElement NannyRoot;
        XElement ContractRoot;

        public Dal_XML_Imp()
        {

            if (!File.Exists(childPath))
                CreateFiles();
            else
                LoadData();
        }

        private void LoadData()
        {
            try
            {
                ChildrenRoot = XElement.Load(childPath);
                NannyRoot = XElement.Load(nannyPath);
                MotherRoot = XElement.Load(motherPath);
                ContractRoot = XElement.Load(contractPath);
            }
            catch
            {
                throw new Exception("File upload problem");
            }
        }
        private void CreateFiles()
        {
            ChildrenRoot = new XElement("children");
            ChildrenRoot.Save(childPath);

            MotherRoot = new XElement("mothers");
            MotherRoot.Save(motherPath);

            NannyRoot = new XElement("nannies");
            NannyRoot.Save(nannyPath);

            ContractRoot = new XElement("contracts");
            ContractRoot.Save(contractPath);
        }

        //if (!File.Exists(childPath))
        //    CreateFiles();
        //else
        //    LoadData();
        //if (!File.Exists(motherPath))
        //    CreateFiles();
        //else
        //    LoadData();
        //if (!File.Exists(nannyPath))
        //    CreateFiles();
        //else
        //    LoadData();
        //if (!File.Exists(contractPath))
        //    CreateFiles();
        //else
        //    LoadData();

        //DS.DataSource.nannies = Nannies();
        //    DS.DataSource.contracts = Contracs();
        //    DS.DataSource.children = Children();
        //    DS.DataSource.mothers = Mothers();

        //    saveListToXML<Mother>(DS.DataSource.mothers, motherPath);
        //    saveListToXML<Child>(DS.DataSource.children, childPath);
        //    saveListToXML<Nanny>(DS.DataSource.nannies, nannyPath);
        //    saveListToXML<Contract>(DS.DataSource.contracts, contractPath);
        

        protected static Dal_XML_Imp instance = null;

        public static Dal_XML_Imp GetInstance()
        {
            if (instance == null) instance = new Dal_XML_Imp();
            return instance;
        }

     
        //private void LoadData()
        //{
        //    try
        //    {
        //        ChildrenRoot = XElement.Load(childPath);
        //        ChildrenRoot = XElement.Load(motherPath);
        //        ChildrenRoot = XElement.Load(contractPath);
        //        ChildrenRoot = XElement.Load(nannyPath);
        //    }
        //    catch
        //    {
        //        throw new Exception("File upload problem");
        //    }
        //}

        //public void SaveChildrenList(List<Child> childList)
        //{
        //    ChildrenRoot = new XElement("children");

        //    foreach (Child item in childList)
        //    {
        //        XElement id = new XElement("id", item.Id);
        //        XElement childGender = new XElement("childGender", item.ChildGender);
        //        XElement motherId = new XElement("motherId", item.MotherId);
        //        XElement name = new XElement("Name", item.FirstName);
        //        XElement birth = new XElement("birth", item.B_Day);
        //        XElement age = new XElement("Age", item.AgeOfChild);
        //        XElement isSpecielNeed = new XElement("isSpecielNeed", item.SpecialNeeds);
        //        XElement image = new XElement("image", item.ImageSource);
        //        XElement specielNeed = new XElement("specielNeed", item.SpecialNeedsDetails);
        //        XElement child = new XElement("child", id, name, motherId, birth, childGender, age, isSpecielNeed, specielNeed, image);
        //        ChildrenRoot.Add(child);
        //    }
        //}
        #endregion

        #region Child

        XElement ConvertChild(BE.Child c)
        {
            XElement childElement = new XElement("child");

            foreach (PropertyInfo item in typeof(BE.Child).GetProperties())
                if (item != null)
                {
                    childElement.Add
                   (
                   new XElement(item.Name, item.GetValue(c, null).ToString())
                   );
                }
            return childElement;

        }
        BE.Child ConvertChild(XElement element)
        {
            Child c = new Child();

            foreach (PropertyInfo item in typeof(BE.Child).GetProperties())
            {
                TypeConverter typeConverter = TypeDescriptor.GetConverter(item.PropertyType);
                object convertValue = typeConverter.ConvertFromString(element.Element(item.Name).Value);

                if (item.CanWrite)
                    item.SetValue(c, convertValue);
            }

            return c;
        }
        public void addChild(Child c)
        {
            Child ch = GetChild(c.Id);
            if (ch != null)
                throw new Exception("child with the same id already exists!");
            c.ImageSource = CopyFiles(c.ImageSource, "pasport_" + c.Id);
            ChildrenRoot.Add(ConvertChild(c));
            ChildrenRoot.Save(childPath);
        }
        private string CopyFiles(string sourcePath, string destinationName)
        {
            try
            {
                int postfixIndex = sourcePath.LastIndexOf('.');
                string postfix = sourcePath.Substring(postfixIndex);
                destinationName += postfix;

                string destinationPath = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
                string destinationFullName = @"images\passport\" + destinationName;

                System.IO.File.Copy(sourcePath, destinationPath + "\\" + destinationFullName, true);
                return destinationFullName;
            }
            catch (Exception ex)
            {

                return @"images\passport\empty_image.jpg";
            }

        }

        public void deleteChild(Child child)
        {
            XElement toRemove = (from item in ChildrenRoot.Elements()
                                 where int.Parse(item.Element("Id").Value) == child.Id
                                 select item).FirstOrDefault();

            if (toRemove == null)
                throw new Exception("Child with the same id not found!");

            toRemove.Remove();

            ChildrenRoot.Save(childPath);
            
        }
        public void updateChildDtails(Child c)
        {
            XElement toUpdate = (from item in ChildrenRoot.Elements()
                                 where int.Parse(item.Element("Id").Value) == c.Id
                                 select item).FirstOrDefault();

            if (toUpdate == null)
                throw new Exception("Child with the same id not found!");

            foreach (PropertyInfo item in typeof(BE.Child).GetProperties())
                toUpdate.Element(item.Name).SetValue(item.GetValue(c).ToString());

            ChildrenRoot.Save(childPath);
        }
        public Child GetChild(int id)
        {
            XElement ch = null;

            try
            {
                ch = (from item in ChildrenRoot.Elements()
                      where int.Parse(item.Element("Id").Value) == id
                      select item).FirstOrDefault();
            }
            catch (Exception)
            {
                return null;
            }

            if (ch == null)
                return null;

            return ConvertChild(ch);
        }
        public IEnumerable<Child> GetAllChildren(Func<Child, bool> predicat = null)
        {
            if (predicat == null)
                if (predicat == null)
                {
                    return from item in ChildrenRoot.Elements()
                           select ConvertChild(item);
                }
            return from item in ChildrenRoot.Elements()
                   let s = ConvertChild(item)
                   where predicat(s)
                   select s;
        }
        public bool existChild(int id)
        {
            if (GetChild(id) != null)
                return true;
            return false;
        }
        #endregion

        #region Nanny
        XElement ConvertNanny(BE.Nanny n)
        {
            XElement nannyElement = new XElement("nanny");

            foreach (PropertyInfo item in typeof(BE.Nanny).GetProperties())
                if (item != null)
                {
                   nannyElement.Add
                   (
                   new XElement(item.Name, item.GetValue(n, null).ToString())
                   );
                }
            return nannyElement;

        }
        BE.Nanny ConvertNanny(XElement element)
        {
            Nanny n = new Nanny();

            foreach (PropertyInfo item in typeof(BE.Nanny).GetProperties())
            {
                TypeConverter typeConverter = TypeDescriptor.GetConverter(item.PropertyType);
                object convertValue = typeConverter.ConvertFromString(element.Element(item.Name).Value);

                if (item.CanWrite)
                    item.SetValue(n, convertValue);
            }

            return n;
        }
        public void addNanny(Nanny n)
        {

            if (existNanny(n.Id))
                throw new Exception("The id is already exist");
            DS.DataSource.nannies.Add(n);

            saveListToXML(DS.DataSource.nannies, nannyPath);
        }
        public void deleteNanny(Nanny temp)
        {
            // var temp = FindNanAcordId(id);
            if (temp != null)
            {
                if (GetAllContracts(c => c.NannyId == temp.Id && c.DateOfEnd < DateTime.Today).Any())
                    throw new Exception("The nanny has at least one valid contract.");

                DataSource.nannies.RemoveAll(n => n.Id == temp.Id);
                DataSource.contracts.RemoveAll(c => c.NannyId == temp.Id);//remove old contracts
                saveListToXML(DS.DataSource.nannies, nannyPath);
                saveListToXML(DS.DataSource.contracts, contractPath);
            }
            else
                throw new Exception("There is no such Nanny");
        }

        public void updateNannyDtails(Nanny n)
        {
            int index = DataSource.nannies.FindIndex(x => x.Id == n.Id);
            if (index == -1)
                throw new Exception("There is no such nanny");
            DataSource.nannies[index] = n;
            saveListToXML(DS.DataSource.nannies, nannyPath);
        }
        public Nanny GetNanny(int id)
        {
            DataSource.nannies = (loadListFromXML<Nanny>(nannyPath));
            var temp = DataSource.nannies.Where(n => n.Id == id);
            foreach (var item in temp)
            {
                return item;
            }
            return null;
        }

        public bool existNanny(int id)
        {
            return GetNanny(id) != null;
        }
        #endregion

        #region Mother
        XElement ConvertMother(BE.Mother m)
        {
            XElement motherElement = new XElement("mother");

            foreach (PropertyInfo item in typeof(BE.Mother).GetProperties())
                if (item != null)
                {
                    motherElement.Add
                    (
                    new XElement(item.Name, item.GetValue(m, null).ToString())
                    );
                }
            return motherElement;

        }
        BE.Mother ConvertMother(XElement element)
        {
            Mother m = new Mother();

            foreach (PropertyInfo item in typeof(BE.Mother).GetProperties())
            {
                TypeConverter typeConverter = TypeDescriptor.GetConverter(item.PropertyType);
                object convertValue = typeConverter.ConvertFromString(element.Element(item.Name).Value);

                if (item.CanWrite)
                    item.SetValue(m, convertValue);
            }

            return m;
        }

        public void addMother(Mother m)
        {
            if (existMother(m.Id))
                throw new Exception("The id is already exist");
            DS.DataSource.mothers.Add(m);

            saveListToXML(DS.DataSource.mothers, motherPath);
        }

        public void deleteMother(Mother m)
        {
            
            if (m != null)
            {
                DataSource.mothers.RemoveAll(n => n.Id == m.Id);              
                saveListToXML(DS.DataSource.mothers, motherPath);
            }
            else
                throw new Exception("There is no such Mother");
        }

        public void updateMotherDtails(Mother m)
        {
            int index = DataSource.mothers.FindIndex(x => x.Id == m.Id);
            if (index == -1)
                throw new Exception("There is no such Mother");
            DataSource.mothers[index] = m;
            saveListToXML(DS.DataSource.mothers, motherPath);
        }

        public Mother GetMother(int id)
        {
            DataSource.mothers = (loadListFromXML<Mother>(motherPath));
            var temp = DataSource.mothers.Where(m => m.Id == id);
            foreach (var item in temp)
            {
                return item;
            }
            return null;
        }

        public bool existMother(int id)
        {
            return GetMother(id) != null;
        }

        #endregion

        #region Contract
        XElement ConvertContract(BE.Contract c)
        {
            XElement contractElement = new XElement("contract");

            foreach (PropertyInfo item in typeof(BE.Contract).GetProperties())
                if (item != null)
                {
                    contractElement.Add
                    (
                    new XElement(item.Name, item.GetValue(c, null).ToString())
                    );
                }
            return contractElement;

        }
        BE.Contract ConvertContract(XElement element)
        {
            Contract c = new Contract();

            foreach (PropertyInfo item in typeof(BE.Mother).GetProperties())
            {
                TypeConverter typeConverter = TypeDescriptor.GetConverter(item.PropertyType);
                object convertValue = typeConverter.ConvertFromString(element.Element(item.Name).Value);

                if (item.CanWrite)
                    item.SetValue(c, convertValue);
            }

            return c;
        }

        public void addContract(Contract c)
        {

            if (!existChild(c.ChildId))
                throw new Exception("The child is not exist");
            if (!existNanny(c.NannyId))
                throw new Exception("The nanny is not exist");

            DS.DataSource.contracts.Add(c);
            saveListToXML(DS.DataSource.contracts, contractPath);
        }

        public void deleteContract(Contract c)
        {
            //  var temp = findContract(id);
            if (c != null)
                DataSource.contracts.RemoveAll(n => n.ContractNumber == c.ContractNumber);
            //     DataSource.contracs.Remove(c);
            else
                throw new Exception("There is no such Contract");
            saveListToXML(DS.DataSource.contracts, contractPath);
        }

        public void updateContractDtails(Contract c)
        {
            int index = DataSource.contracts.FindIndex(x => x.ContractNumber == c.ContractNumber);
            if (index == -1)
                throw new Exception("There is no such contract");
            DataSource.contracts[index] = c;
            saveListToXML(DS.DataSource.contracts, contractPath);
        }

        public Contract getContract(int id)
        {
            var temp = (DataSource.contracts.Where(n => n.ContractNumber == id)).ToList();
            foreach (var item in temp)
            {
                return item;
            }
            return null;
        }

        #endregion

        #region General Functions
        public IEnumerable<Nanny> GetAllNannies(Func<Nanny, bool> predicat = null)
        {
            return predicat == null ? (loadListFromXML<Nanny>(nannyPath)) : (loadListFromXML<Nanny>(nannyPath)).FindAll(x => predicat(x));
        }

        public IEnumerable<Mother> GetAllMothers(Func<Mother, bool> predicat = null)
        {
            return predicat == null ? (loadListFromXML<Mother>(motherPath)) : (loadListFromXML<Mother>(motherPath)).FindAll(x => predicat(x));
        }

        public IEnumerable<Child> getChildren(Mother m)
        {
            return GetAllChildren(c => c.MotherId == m.Id);
        }

        public IEnumerable<Contract> GetAllContracts(Func<Contract, bool> predicat = null)
        {
            return predicat == null ? (loadListFromXML<Contract>(contractPath)) : (loadListFromXML<Contract>(contractPath)).FindAll(x => predicat(x));
        }

        public List<Contract> Contracs()
        {
            return GetAllContracts().ToList();
        }

        public List<Mother> Mothers()
        {
            return GetAllMothers().ToList();
        }
        public List<Nanny> Nannies()
        {
            return GetAllNannies().ToList();
        }

        public List<Child> Children()
        {
            return GetAllChildren().ToList();
        }

        public List<Nanny> getNannies()
        {
            return DataSource.nannies;
        }
        public List<Mother> getMothers()
        {
            return DataSource.mothers;
        }
        public List<Child> getChildren(List<Child> childrenByMothers)
        {
            childrenByMothers = new List<Child>();

            foreach (Mother item in DataSource.mothers)
            {
                foreach (Child child in item.ChildrenList)
                {
                    if (child.NumOfConracts > 0)
                    {
                        childrenByMothers.Add(child);
                    }
                    else
                    { }
                }
            }
            return DataSource.children;
        }

        public List<Contract> getContract()
        {
            return DataSource.contracts;
        }

        public static void saveListToXML<T>(List<T> list, string Path)
        {
            FileStream file = new FileStream(Path, FileMode.Create);
            XmlSerializer x = new XmlSerializer(list.GetType());
            x.Serialize(file, list);
            file.Close();
        }

        public static List<T> loadListFromXML<T>(string path)
        {
            List<T> list;
            XmlSerializer x = new XmlSerializer(typeof(List<T>));
            FileStream file = new FileStream(path, FileMode.Open);
            list = (List<T>)x.Deserialize(file);
            file.Close();
            return list;
        }



        #endregion
    }
}
