﻿using BE;
using DAL;
using DS;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DAL
{
    class Dal_imp: Idal
    {

        #region Nanny's functions
        List<Nanny> listNany;
        public Dal_imp()
        {
            listNany = new List<Nanny>();
        }
        public IEnumerable<Nanny> GetAllNannies(Func<Nanny, bool> predicat = null) 
        {
            if (predicat == null)
                return DataSource.nannies.AsEnumerable();
            return DataSource.nannies.Where(predicat);
        }

        public void addNanny(Nanny n)
        {
            Nanny nadd = GetNanny(n.Id);
            
            if(nadd != null)

            throw new Exception("This Nanny Already Exists");   
            DataSource.nannies.Add(n);
        }

        public Nanny GetNanny(int Id)
        {
            return DataSource.nannies.FirstOrDefault(n => n.Id == Id); 
        }

        public void deleteNanny(Nanny n)
        {
                Nanny ndelete = GetNanny(n.Id);

            if (ndelete != null)
            {
                foreach (Child item in ndelete.ChildList)
                {
                    ndelete.ChildList.Remove(item);
                }
                foreach (Contract item in ndelete.ContractList)
                {
                    ndelete.ContractList.Remove(item);
                    DataSource.contracts.Remove(item);
                }

                DataSource.nannies.Remove(n);
            }
            else
                throw new Exception("WE DONT HAVE THIS NANNY!!!");
        }

        public void updateNannyDtails(Nanny n)
        {
            deleteNanny(n);
            addNanny(n);
        }
        #endregion

        #region Mother's functions 
        public IEnumerable<Mother> GetAllMothers(Func<Mother, bool> predicat = null)
        {
            if (predicat == null)
                return DataSource.mothers.AsEnumerable();

            return DataSource.mothers.Where(predicat);
        }

        public void addMother(Mother m)
        {
            Mother madd = GetMother(m.Id);

            if (madd != null)

                throw new Exception("This Mother Already Exists");
            DataSource.mothers.Add(m);
        }
        public Mother GetMother(int Id)
        {
            return DataSource.mothers.FirstOrDefault(m => m.Id == Id);

        }
      
        public void deleteMother(Mother m)
        {
            Mother mdelete = GetMother(m.Id);

            if (mdelete != null)
            {
                DataSource.mothers.Remove(m);
            }
            else
                throw new Exception("WE DONT HAVE THIS MOTHER!!!");
        }
        public void updateMotherDtails(Mother m)
        {
            deleteMother(m);
            addMother(m);
        }
        #endregion

        #region Child's function
        
        public IEnumerable<Child> GetAllChildren(Func<Child, bool> predicat = null)
        {
            if (predicat == null)
                return DataSource.children.AsEnumerable();

            return DataSource.children.Where(predicat);
        }

        public void addChild(Child c)
        {
            Child cadd = GetChild(c.Id);

            if (cadd != null)
                throw new Exception("This Child Already Exists");
            DataSource.children.Add(c);
            Mother madd = GetMother(c.MotherId);
            madd.ChildrenList.Add(c); //add the child to the mother's children list
        }

        public Child GetChild(int Id)
        {
            return DataSource.children.FirstOrDefault(c => c.Id == Id);

        }

        public void deleteChild(Child c)
        {
            Child cdelete = GetChild(c.Id);

            if (cdelete != null)
            {
                Mother madd = GetMother(c.MotherId);
                madd.ChildrenList.Remove(c);
                DataSource.children.Remove(c);
                if(c.NumOfConracts!=0)
                {
                  foreach(Nanny n in DataSource.nannies)
                    {
                        foreach(Child cH in n.ChildList)
                        {
                            if(cH.Id==c.Id)
                            {
                                n.ChildList.Remove(cH);
                            }
                        }

                        foreach (Contract con in n.ContractList)
                        {
                            if (con.ChildId == c.Id)
                            {
                                n.ContractList.Remove(con);
                            }
                        }

                    }
                }
                
            }
            else
                throw new Exception("WE DONT HAVE THIS CHILD!!!");
        }

        public void updateChildDtails(Child c)
        {
            deleteChild(c);
            addChild(c);
        }
        #endregion

        #region Contract's functions
        public static int contractNum = 11111111;  

        public IEnumerable<Contract> GetAllContracts(Func<Contract, bool> predicat = null)
        {
            if (predicat == null)
                return DataSource.contracts.AsEnumerable();

            return DataSource.contracts.Where(predicat);
        }

        public void addContract(Contract co)
        {
            Contract coadd = getContract(co.ContractNumber); 

            if (coadd != null)

                throw new Exception("This Contract Already Exists");
            else
            {
                Nanny nadd = GetNanny(co.NannyId); //checks if the nanny and the mother exist
                if (nadd == null)
                    throw new Exception("WE DONT HAVE THIS NANNY!!");
                else
                {
                    int idChild = co.ChildId;
                    Child tmpchild = GetChild(co.ChildId);
                    int mid = tmpchild.MotherId;
                    Mother madd = GetMother(mid);
                    if (madd == null)
                        throw new Exception("WE DONT HAVE THIS Mother!!");
                    tmpchild.NumOfConracts++;
                    DataSource.contracts.Add(co);
                    Nanny cToNanny = GetNanny(co.NannyId);
                    cToNanny.ContractList.Add(co);
                    cToNanny.ChildList.Add(tmpchild);
                   
                    contractNum++;
                }           
            }    
        }

        public Contract getContract(int ContractNumber)
        {
            return DataSource.contracts.FirstOrDefault(co => co.ContractNumber == ContractNumber);
        }

        public void deleteContract(Contract co)
        {
            Contract cdelete = getContract(co.ContractNumber);

            if (cdelete != null)
            {

                int idChild = co.ChildId;
                Child tmpchild = GetChild(co.ChildId);
                tmpchild.NumOfConracts--;
                DataSource.contracts.Remove(co);
            }
            else
                throw new Exception("WE DONT HAVE THIS CONTRACT!!!");
          } 

        public void updateContractDtails(Contract co)
        {
            deleteContract(co);
            addContract(co);
        }
        #endregion

        #region General functions
        public List<Nanny> getNannies()
        {
            return DataSource.nannies;
        }
        public List<Mother> getMothers()
        {
            return DataSource.mothers;
        }
        public List<Child> getChildren(List<Child> childrenByMothers)
        {
           childrenByMothers=new List<Child>();

            foreach (Mother item in DataSource.mothers)
            {
                foreach (Child child in item.ChildrenList)
                {
                    if (child.NumOfConracts > 0)
                    {
                        childrenByMothers.Add(child);
                    }
                    else
                    { }
                }
            }
            return DataSource.children;
        }

        public List<Contract> getContract()
        {
            return DataSource.contracts;
        }
        #endregion

    }
}
