﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Drawing;

namespace UI
{
    /// <summary>
    /// Interaction logic for CHILDWINDOW.xaml
    /// </summary>
    public partial class Child : Window
    {

        BE.Child child;
        BL.IBL bl;
       
        public Child(string status, BE.Child c = null)
        {
            InitializeComponent();
            bl = BL.FactoryBL.GetBL();
            child = new BE.Child();
            childGrid.DataContext = child;
            if (status == "ADDC")
            {
                UpdaeChild_Btn.Visibility = Visibility.Hidden;
                child = new BE.Child();
                childGrid.DataContext = child;
                this.childGenderComboBox.ItemsSource = Enum.GetValues(typeof(BE.Gender));
                UpdaeChild_Btn.Visibility = Visibility.Hidden;
                AddChild_Btn.Visibility = Visibility.Visible;
            }
            if (status == "UPDATEC")
            {
                AddChild_Btn.Visibility = Visibility.Hidden;
                UpdaeChild_Btn.Visibility = Visibility.Visible;
                childGrid.DataContext = c;
                idTextBox.IsEnabled = false;
                UpdaeChild_Btn.Visibility = Visibility.Visible;

            }

        }

        private void changeImage_BtnClick(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.OpenFileDialog f = new Microsoft.Win32.OpenFileDialog();
            f.Filter = "JPG Files (*.jpg)|*.jpg|PNG Files (*.png)|*.png|JPG Files (*.jpg)|*.jpg|GIF Files (*.gif)|*.gif";
            if (f.ShowDialog() == true)
            {
                this.childImage.Source = new BitmapImage(new Uri(f.FileName));

            }

        }

        private void AddChild_BtnClick(object sender, RoutedEventArgs e)
        {
            try
            {
   
                bl.addChild(child);
                childGrid.DataContext = child;
                MessageBox.Show("added seccesfully" +"\n"+ child.Id);
              }
          
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}




