﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Drawing;

namespace UI
{
    /// <summary>
    /// Interaction logic for MOTHERWINDOW.xaml
    /// </summary>
    public partial class Mother : Window
    { string status;
        BE.Mother mother;
        BE.Nanny nanny;
        BE.Child child;
        BL.IBL bl;
        public Mother(string status1, BE.Mother m1=null)
        {
            InitializeComponent();
            status = status1;
            bl = BL.FactoryBL.GetBL();
             mother = new BE.Mother();

            MotherGride.DataContext = mother;
            if (status1=="ADDM")
            {           
            UpdateMother_Btn.Visibility = Visibility.Hidden;                                             
            AddChild_Btn.Visibility = Visibility.Hidden;
            UpdateChild_Btn.Visibility = Visibility.Hidden;
            AddContract_Btn.Visibility = Visibility.Hidden;
            NanniesListComboBox.Visibility = Visibility.Hidden;
            RemoveMother.Visibility = Visibility.Hidden;
                mother = new BE.Mother();
                MotherGride.DataContext = mother;

            }
           else if(status1 == "UPDATEM")
            {
                mother = m1;
                MotherGride.DataContext = mother;
                GoToSchedule_Btn.Visibility = Visibility.Hidden;
                this.NanniesListComboBox.ItemsSource = bl.GetAllNannies();
                this.NanniesListComboBox.DisplayMemberPath = "FirstName";
                this.NanniesListComboBox.SelectedValuePath = "Id";

            }
        }

      

        private void AddChild_Btn_Click(object sender, RoutedEventArgs e)
        {
            status = "ADDC";
            //  new Child(status).Show();
            Window c = new Child(status);
                c.Show();
        }

     

        private void AddMother_BtnClick(object sender, RoutedEventArgs e)
        {
            try
            {
              
                bl.addMother(mother);
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void MouseButton_scheduel(object sender, MouseButtonEventArgs e)
        {
           
            if (status == "ADDM")
            {
                new Schedeul("ADDM", mother, null).Show();
            }
            if (status == "UPDATEM")

                new Schedeul("UPDATEM", mother, null).Show();
        }

        //private void Label_MouseEnter(object sender, MouseEventArgs e)
        //{
        //    txtblock.FontSize = 26;
        //}

        //private void txtblock_MouseLeave(object sender, MouseEventArgs e)
        //{
        //    txtblock.FontSize = 18;

        //}

        private void button_Click(object sender, RoutedEventArgs e)
        {
           
            if (status == "ADDM")
            {
                new Schedeul("ADDM", mother, null).Show();
            }
            if (status == "UPDATEM")

                new Schedeul("UPDATEM", mother, null).Show();
            this.Close();
        }

        private void UpdateChild_Btn_Click(object sender, RoutedEventArgs e)
        {
            childToUpdateId_TxtBox.Visibility = Visibility.Visible;
            status = "UPDATEC";
            int id;
            int.TryParse(childToUpdateId_TxtBox.Text, out id);
            BE.Child child = bl.GetChild(id);
            
        }



        private void InsertChildID_txtBox(object sender, KeyboardFocusChangedEventArgs e)
        {
            try
            {

            
            int id;
            int.TryParse(childToUpdateId_TxtBox.Text, out id);
            BE.Child child = bl.GetChild(id);
            if (child == null)
               throw new Exception("CHILD WAS NOT FOUND");
            else
                {
                    status = "UPDATEC";
                    new Child(status,child).Show();
                }
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void mouse_click_UpdateChildTxtBox(object sender, MouseButtonEventArgs e)
        {
            childToUpdateId_TxtBox.Text = "";
        }

        private string GetSelectedNanniesName()
        {
            object result = this.NanniesListComboBox.DisplayMemberPath;
            if (result == null)
                throw new Exception("must select nanny first");
            return (string)result;
        }


        private void NanniesListComboBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (sender is ComboBox && ((ComboBox)sender).SelectedIndex > -1)
            {
                this.firstNameTextBox.Text = GetSelectedNanniesName();
                int id;
                int.TryParse(NanniesListComboBox.SelectedValuePath, out id);
                nanny = bl.GetNanny(id);
                new Nanny("SHOW",nanny ).Show();

            }
        }

        private void AddContract_Btn_Click(object sender, RoutedEventArgs e)
        {
            new Contract().Show();
        }
    }
}
