﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace UI
{
    /// <summary>
    /// Interaction logic for NannyWindow.xaml
    /// </summary>
    public partial class Nanny : Window
    {
        BE.Nanny nanny;
        BL.IBL bl;
        
        public Nanny(string status1, BE.Nanny n1 = null)
        {
            InitializeComponent();
            bl = BL.FactoryBL.GetBL();
            nanny = new BE.Nanny();
            nannyGrid.DataContext = nanny;
           
            if (status1 == "ADD")
            {
                UpdateNannyBTn.Visibility = Visibility.Hidden;
               
                UpdateBtn.Visibility = Visibility.Hidden;
                update1.Visibility = Visibility.Hidden;
                nanny = new BE.Nanny();
                nannyGrid.DataContext = nanny;

            }
            else if (status1 == "UPDATE")
            {
                UpdateNannyBTn.Visibility = Visibility.Visible;
                
                UpdateBtn.Visibility = Visibility.Visible;
                update1.Visibility = Visibility.Visible;
                comboBox.Visibility = Visibility.Visible;
                UpdateNannyBTn.Visibility = Visibility.Visible;
                nannyGrid.DataContext = n1;
                nannyGrid.IsEnabled = false;
                
            }
        }


           
          
        



            private void deleteNanny_btnClick(object sender, RoutedEventArgs e)
            {
                try
                {
                    bl.deleteNanny(nanny);

                    this.Close();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }

            private void UpdateNanny_btnClick(object sender, RoutedEventArgs e)
            {

                try
                {
                    bl.updateNannyDtails(nanny);

                    this.Close();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }

            private void update1_SelectionChanged(object sender, SelectionChangedEventArgs e)
            {
                if ((update1.SelectedIndex)==0)
                {
                    nannyGrid.IsEnabled = true;
                    idTextBox.IsEnabled = false;
                }
                else if ((update1.SelectedIndex) == 1)
                {
                int id;
                int.TryParse(idTextBox.Text, out id);
                BE.Nanny nanny = bl.GetNanny(id);
                new Schedeul("UPDATEN",null,nanny).Show();
                }
            }

            private void UpdateBtn_Click(object sender, RoutedEventArgs e)
            {
                update1.Visibility = Visibility.Visible;
            }

        private void BackToHome_BtnClick(object sender, RoutedEventArgs e)
        {
            this.Close();
            new Welcome().Show();
        }



        private void GoToSchhedule_NanntBtn_Click(object sender, RoutedEventArgs e)
        {
            new Schedeul("ADDN", null, nanny).Show();
        }
    }
    }



