﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace UI
{
    /// <summary>
    /// Interaction logic for NumericUpdownControl.xaml
    /// </summary>
    public partial class NumericUpDownControl : UserControl
    {
        public int ezer;


        public float? Value
        {
            get { return (float?)GetValue(ValueProperty); }
            set { SetValue(ValueProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Value.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty ValueProperty =
            DependencyProperty.Register("Value", typeof(float?), typeof(NumericUpDownControl),
                new PropertyMetadata(null, PropertyChangedCallback, ValueCoerceValueCallback));



        public static object ValueCoerceValueCallback(DependencyObject d, object baseValue)
        {
            float? value = baseValue as float?;
            NumericUpDownControl THIS = d as NumericUpDownControl;
            if (value > THIS.MaxValue)
                return (float?)THIS.MaxValue;
            else if (value < THIS.MinValue)
                return (float?)THIS.MinValue;
            else return value;
        }

        public static void PropertyChangedCallback(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            NumericUpDownControl THIS = d as NumericUpDownControl;
            THIS.txtnr.Text = THIS.Value == null ? "" : THIS.Value.ToString();
        }


        

        public int MinValue
    {
            get { return (int)GetValue(MaxValueProperty); }
            set { SetValue(MaxValueProperty, value); }
        }



        public int MaxValue
        {
            get { return (int)GetValue(MinValueProperty); }
            set { SetValue(MinValueProperty, value); }
        }
        public static readonly DependencyProperty MinValueProperty =
      DependencyProperty.Register("MinValue", typeof(int), typeof(NumericUpDownControl), new PropertyMetadata(0));

        // Using a DependencyProperty as the backing store for MaxValue.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty MaxValueProperty =
       DependencyProperty.Register("MaxValue", typeof(int), typeof(NumericUpDownControl), new PropertyMetadata(24));





        public NumericUpDownControl()
        {
            InitializeComponent();
            MaxValue = 24;
            MinValue = 0;
            Value = 0;
            ezer = 0;
        }



        private void cmdUp_Click(object sender, RoutedEventArgs e)
        {

            if(Value==(float?)(23.59))
            {

                Value = 0;
            }
           else if((Value-(int)Value)<0.59 && Value != 24)
            Value = Value + (float)(0.01);
            else if(Value== 24)
                Value =0;
            else
                Value = (int)Value + (float)(1);
        }

        private void cmdDown_Click(object sender, RoutedEventArgs e)
        {
            if ((Value - (int)Value) > 0)
                Value = Value - (float)(0.01);
            else
                Value = ((int)Value - (float)(1))+ (float)(0.59);
            
        }
       

        private void txtnr_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (txtnr == null || this.txtnr.Text == "" || txtnr.Text == "-")
            {
                Value = null;
                return;
            }

            float val;
            if (!float.TryParse(txtnr.Text, out val))
            {
                ezer = (int)Value;
                if (ezer < 10)
                {
                    txtnr.Text = "0" + Value.ToString();
                }
                else txtnr.Text = Value.ToString();
            }
            else
                Value = val;
        }
    }
}
