﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Drawing;
using System.ComponentModel;


namespace UI
{
    /// <summary>
    /// Interaction logic for Welcome!.xaml
    /// </summary>
    public partial class Welcome : Window
    {
        string status = "";
        static BL.Bl_imp bl = new BL.Bl_imp();
        public Welcome()
        {
            InitializeComponent();
         
        }

        [BrowsableAttribute(true)]
        public System.Drawing.Color MouseOverBackColor { get; set; }


        private void ComboBox1_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if ((ComboBox1.SelectedIndex) == -1)
            {
                return;
            }
            else
            {
                status = "ADD";
                if ((ComboBox1.SelectedIndex) == 1)//Text.Equals("Mother"))
                {
                    new Mother(status + "M").Show();
                    this.Close();
                    ComboBox1.Visibility = Visibility.Hidden;
                    ComboBox1.SelectedIndex = -1;


                }
                else if ((ComboBox1.SelectedIndex) == 0)
                {
                    new Nanny(status + "N").Show();
                    this.Close();
                    ComboBox1.Visibility = Visibility.Hidden;
                    ComboBox1.SelectedIndex = -1;
                }


            }


        }

        private void btnloginClick(object sender, RoutedEventArgs e)
        {
            labelid.Visibility = Visibility.Visible;
            textBoxid.Visibility = Visibility.Visible;
            btnokb.Visibility = Visibility.Visible;
            if (ComboBox1.IsVisible == true)
            {
                ComboBox1.Visibility = Visibility.Hidden;
            }
        }

        private void btnsigsup(object sender, RoutedEventArgs e)
        {
            ComboBox1.Visibility = Visibility.Visible;
            if (labelid.IsVisible == true)
            {
                labelid.Visibility = Visibility.Hidden;
                textBoxid.Visibility = Visibility.Hidden;
                btnokb.Visibility = Visibility.Hidden;

            }
            else
            { }
        }

        private void btnokbtn(object sender, RoutedEventArgs e)
        {
            try
            {
                int id;
                int.TryParse(textBoxid.Text, out id);
                BE.Mother mother1 = bl.GetMother(id);
                BE.Nanny nanny1 = bl.GetNanny(id);
                if ((mother1 != null) && (nanny1 != null))
                {
                    comboBoxMotherOrNanny.Visibility = Visibility.Visible;
                }
                else if ((mother1 != null))
                {
                    status = "UPDATEM";
                    new Mother(status, mother1).Show();
                    this.Close();
                }
                else if ((nanny1 != null))
                {
                    status = "UPDATEN";
                    new Nanny(status, nanny1).Show();
                    this.Close();
                }
                else if ((nanny1 == null) && (mother1 == null))
                    throw new Exception("CANT FOUND ID");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }

        private void comboBoxMotherOrNanny_selectedChanged(object sender, SelectionChangedEventArgs e)
        {
            status = "UPDATE";
            int id;
            int.TryParse(textBoxid.Text, out id);
            if ((comboBoxMotherOrNanny.SelectedIndex) == 0)
            {

                BE.Nanny nanny1 = bl.GetNanny(id);
                new Nanny(status, nanny1).Show();
                this.Close();
            }
            else
            {
                BE.Mother mother1 = bl.GetMother(id);
                new Mother(status, mother1).Show();
                this.Close();
            }
        }

       
    }
}
