#include "Account.h"
#include <string>
float Account::sumDeposit = 0;
float Account::sumWithdraw = 0;
Account::Account(int a, int c, float b)
{
	accountNumber = a;
	code = c;
	balance = b;
}

void Account::setBalance(float b)
{
	balance = b;
}

int Account::getAccountNumber()
{
	return accountNumber;
}

int Account::getCode()
{
	return code;
}

float Account::getBalance()
{
	return balance;
}

void Account::withdraw(float nis, bool f)
{
	try
	{
		if (nis > 2500)
		{
			throw string("cannot withdraw more than 2500 NIS!");
		}
		if ((balance - nis) < -6000)
		{
			throw string("cannot have less than - 6000 NIS!");
		}
		balance -= nis;
		sumWithdraw += nis;
	}
	catch (const string str)
	{
		cout << "ERROR: " << str << endl;
		f = false;
	}
}

void Account::deposit(float nis, bool f)
{
	try
	{
		if (nis > 10000)
		{
			throw string("ERROR: cannot deposit more than 10000 NIS!");
		}
		balance += nis;
		sumDeposit += nis;
	}
	catch (const string str)
	{
		cout << str << endl;
		f = false;
	}
}

float Account::getSumDeposit()
{
	return sumDeposit;
}

float Account::getSumWithdraw()
{
	return sumWithdraw;
}

istream & operator >> (istream & is, Account & a)
{
	a.balance = 0;
	try
	{
		is >> a.accountNumber >> a.code;
		if (a.code < 1000)
		{
			throw string("ERROR: code must be of 4 digits!");
		}
		return is;
	}
	catch (const string str)
	{
		cout << str << endl;
	}
	a.accountNumber = 0;
	a.code = 0;
	// TODO: insert return statement here
}
