#include "Clock.h"
#include <string>
Clock::Clock(int h, int m, int s)
{
	if ((h < 24) && (h >=0) && (m < 60) && (m >= 0) && (s < 60) && (s >= 0))
	{
		hour = h;
		minute = m;
		second = s;
	}
	else
	{
		hour = 0;
		minute = 0;
		second = 0;
	}
}

Clock::Clock(const Clock & t)
{
	hour = t.hour;
	minute = t.minute;
	second = t.second;
}

void Clock::setHour(int n)
{
	hour = n;
}

void Clock::setMinute(int n)
{
	minute = n;
}

void Clock::setSecond(int n)
{
	second = n;
}

int Clock::getHour()
{
	return hour;
}

int Clock::getMinute()
{
	return minute;
}

int Clock::getSecond()
{
	return second;
}

Clock Clock::operator+=(int numOfSeconds)
{
	second += numOfSeconds;
	while (second > 59)
	{
		second -= 60;
		minute += 1;
	}
	while (minute > 59)
	{
		minute -= 60;
		hour += 1;
	}
	while (hour > 23)
	{
		hour -= 24;
	}
	return *this;
}

ostream & operator<<(ostream & os, Clock t)
{
	if (t.hour < 10)
	{
		os << '0';
	}
	os << t.hour << ':';
	if (t.minute < 10)
	{
		os << '0';
	}
	os << t.minute << ':';
	if (t.second < 10)
	{
		os << '0';
	}
	os << t.second;
	return os;
	// TODO: insert return statement here
}

istream & operator >> (istream & is, Clock & t)
{
	char ch1, ch2;
	try
	{
		is >> t.hour >> ch1 >> t.minute >> ch2 >> t.second;
		if ((ch1 != ':') || (ch2 != ':'))
		{
			throw string("Wrong time format.");
		}
		
		if (t.hour > 23)
		{
			throw string("Invalid time - more than 24 hours.");
		}
		if (t.hour < 0)
		{
			throw string("Invalid time - negative number of hours.");
		}
		if (t.minute > 59)
		{
			throw string("Invalid time - more than 60 minutes.");
		}
		if (t.minute < 0)
		{
			throw string("Invalid time - negative number of minutes.");
		}
		if (t.second > 59)
		{
			throw string("Invalid time - more than 60 seconds.");
		}
		if (t.second < 0)
		{
			throw string("Invalid time - negative number of seconds.");
		}
		return is;
	}
	catch (string str)
	{
		cout << str << endl;
	}
	t.hour = 0;
	t.minute = 0;
	t.second = 0;
	// TODO: insert return statement here
}
