#include "Clock.h"
#include "Account.h"
#include <iostream>
#include <string>
using namespace std;
enum action
{
	stop,
	balance,
	withdraw,
	deposit,
	sumDeposit,
	sumWithdraw
};
action menu()
{
	cout << "enter " << balance << " to get account balance" << endl;
	cout << "enter " << withdraw << " to withdraw money" << endl;
	cout << "enter " << deposit << " to deposit money" << endl;
	cout << "enter " << sumDeposit << " to see the sum of all Deposits" << endl;
	cout << "enter " << sumWithdraw << " to see the sum of all withdraws" << endl;
	cout << "enter " << stop << " to stop" << endl;
	int opt;
	cin >> opt;
	return (action)opt;
}
int findAccount(Account* bank, int size)
{
	int number, code;
	cout << "please enter account number: ";
	cin >> number;
	int i = 0;
	try
	{
		while (i < size && bank[i].getAccountNumber() != number)
			i++;
		if (i == size)
		{
			throw string("no such account number!");
		}
		cout << "please enter the code: ";
		cin >> code;
		if (code < 1000)
		{
			throw string("code must be of 4 digits!");
		}
		if (bank[i].getCode() == code)
			return i;
		else
			throw string("wrong code!");
	}
	catch (const string str)
	{
		cout << "ERROR: " << str << endl;
	}
	return -1;
}
void printTransaction(Account a, action ac)
{
	Clock c;
	cout << c << "\t";

	switch (ac)
	{
	case balance: cout << "account #: " << a.getAccountNumber() << "\t";
		cout << "balance: " << a.getBalance() << endl;
		break;
	case deposit:
	case withdraw: cout << "account #: " << a.getAccountNumber() << "\t";
		cout << "new balance: " << a.getBalance() << endl;
		break;
	case sumDeposit:
		cout << "sum of all deposits: " << Account::getSumDeposit() << endl;
		break;
	case sumWithdraw:
		cout << "sum of all withdraws: " << Account::getSumWithdraw() << endl;
		break;
	}
}
void getBalance(Account* bank, int size)
{
	int i = findAccount(bank, size);
	if (i!=-1)
	{
		printTransaction(bank[i], balance);
	}
}
void checkDeposit(Account* bank, int size)
{
	int i = findAccount(bank, size);
	if (i != -1)
	{
		float amount;
		cout << "enter the amount of the check: ";
		cin >> amount;
		bool flag = true;
		bank[i].deposit(amount, &flag);
		if (flag)
		{
			printTransaction(bank[i], deposit);
		}
	}
}
void cashWithdraw(Account* bank, int size)
{
	int i = findAccount(bank, size);
	if (i != -1)
	{
		float amount;
		cout << "enter the amount of money to withdraw: ";
		cin >> amount;
		bool flag = true;
		bank[i].withdraw(amount, &flag);
		printTransaction(bank[i], withdraw);
	}
}
bool chekAccountNumber(Account *bank, int size, int i)
{
	for (int j = 0; j < i; j++)
	{
		if (bank[j].getAccountNumber() == bank[i].getAccountNumber())
			return true;
	}
	return false;
}
int main()
{
	const int NUM_OF_ACCOUNTS = 4;
	Account bank[NUM_OF_ACCOUNTS];
	cout << "enter account number and code for " << NUM_OF_ACCOUNTS << " accounts:" << endl;
	for (int i = 0; i < NUM_OF_ACCOUNTS; ++i)
	{
		try
		{
			cin >> bank[i];
			if (chekAccountNumber(bank, NUM_OF_ACCOUNTS, i))
			{
				throw string("account number must be unique!");
			}
		}
		catch (const string str)
		{
			cout << "ERROR: " << str << endl;
			--i;
		}
		
	}
	action ac = menu();
	while (ac)
	{
		switch (ac)
		{
		case balance:  getBalance(bank, NUM_OF_ACCOUNTS);
			break;
		case withdraw: cashWithdraw(bank, NUM_OF_ACCOUNTS);
			break;
		case deposit:  checkDeposit(bank, NUM_OF_ACCOUNTS);
			break;
		case sumDeposit: printTransaction(bank[0], sumDeposit);
			break;
		case sumWithdraw: printTransaction(bank[0], sumWithdraw);

		}
		ac = menu();
	}
	//char c;
	//cin >> c;
	return 0;
}